FUNCTION_BLOCK FB_heating_valve_position_calculation
VAR_INPUT
PID_value						: REAL ;
END_VAR

VAR_OUTPUT
Heating_Coil_Valve_Position		: REAL ;
END_VAR

VAR
rTemp, rTemp2		 			: REAL ;
END_VAR
(* calculate heating coil valve position ****************************************************************** *)
IF Heating_Coil_Return_Water_Temperature_Safety_P_Band<>0.0 THEN											(* first itteration, the value may not be loaded yet *)
	rTemp  := Heating_Coil_Return_Water_Temperature_Alarm_Limit + Heating_Coil_Return_Water_Temperature_Safety_P_Band - Heating_Coil_Return_Water_Temperature_Measurement ;
	IF rTemp>0.0 THEN																						(* measurement is in danger zone *)
		rTemp2 := rTemp / Heating_Coil_Return_Water_Temperature_Safety_P_Band ;								(* calculate desired position from the safety part *)
		rTemp2 := MIN (rTemp2, 100.0) ;																		(* make sure we send maximum 100 *)
		Heating_Coil_Valve_Position := MAX (rTemp2, PID_value) ;										(* if the PID wants more than the safety requires, send that *)
	ELSE																									(* measurement is OK and system is not in danger of freezing *)
		Heating_Coil_Valve_Position := PID_value ;															(* set valve to PID stage5 output *)
	END_IF ;
ELSE	
	Heating_Coil_Valve_Position := 0.0 ;																	(* during startup of the moduel; let's keep the valve closed *)
END_IF ;		
END_FUNCTION_BLOCK